
#ifndef SST_EXT_ATP_DATA_H
#define SST_EXT_ATP_DATA_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
 #include "SST_Ext_DEFINES.h"
 #include "sst_types.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Data.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Data operations test struct*/
typedef struct Ext_ATP_DataOpTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxUint32_t                  TST_DataReadOffset;
    DxByte_t                    TST_DataToWrite[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataToWriteSize;
    DxUint32_t                  TST_DataToWriteOffset;
    DxByte_t                    TST_ModifedData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    SSTHandle_t                 TST_DataHandle;
    SSTHandle_t                 TST_AuthHandle;
} Ext_ATP_DataOpTestDataStruct;



typedef struct Ext_ATP_BindingWritingPermissionsStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_NSizeInBytes;
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_DSizeInBytes;
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize; 
    DxByte_t                    TST_SignedChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxUint32_t                  TST_KeySizeInBytes;
    DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxUint32_t                  TST_DataReadOffset;
    DxByte_t                    TST_DataToWrite[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataToWriteSize;
    DxUint32_t                  TST_DataToWriteOffset;
    DxByte_t                    TST_ModifedData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} Ext_ATP_BindingWritingPermissionsStruct;



/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_BasicDataOp         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 ********************************************************************************/   
DxError_t SST_Ext_ATP_BasicDataOp ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_BasicUnAuthnticatedDataOp       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the insertion, deletion, modification, opening, getting data size for a data object using default internal authenticator.
 * And demonstration on the use of transaction with data objects
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/
DxError_t SST_Ext_ATP_BasicUnAuthnticatedDataOp ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_BindingWritingPermissions       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the bind and unbind authenticator to data object capabilities of the SST
 * NOTE: this is a test that has error return values as a correct matter or operation!
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
DxError_t SST_Ext_ATP_BindingWritingPermissions ( void );



/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ReadOnlyData       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test data replace operation
 *
 * Algorithm:       
 *    1.Call to  SST_Terminate. 
 *    2.Call to  SST_Init.
 *    3.Call to HOSTQA_ATP_Message function
 *    4.Call to  SST_Terminate. 
 *    5.Call to  SST_Init.
 *******************************************************************************/ 
DxError_t SST_Ext_ReadOnlyData ( void );
 
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_DataReplace       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test data replace operation
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 DxError_t SST_Ext_ATP_DataReplace ( void );



#ifdef __cplusplus
}
#endif

#endif

